'use strict';

/* --------------------------------------------------------------
 product_min_height_fix.js 2016-05-23
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Widget that fixes min height of product info content element
 */
gambio.widgets.module('product_min_height_fix', [gambio.source + '/libs/events'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $window = $(window),
        defaults = {
        productInfoContent: '.product-info-content' // Selector to apply min height to
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    // ########## HELPER FUNCTIONS ##########		

    /**
     * Fix for problem that box overlaps content like cross selling products if product content is too short
     *
     * @private
     */
    var _setProductInfoContentMinHeight = function _setProductInfoContentMinHeight() {
        $(options.productInfoContent).css('min-height', $this.outerHeight() + parseFloat($this.css('top')) + 'px');
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     * @constructor
     */
    module.init = function (done) {
        _setProductInfoContentMinHeight();

        $window.on(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE(), _setProductInfoContentMinHeight);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
